﻿//***************************************************************************************
// BlurFilter.h Frank Luna (C) 2011 Wszelkie prawa zastrzeżone.
//
// Wykonuje operację rozmycia na najwyższym poziomie mip wejściowej tekstury.
//***************************************************************************************

#ifndef BLURFILTER_H
#define BLURFILTER_H

#include <Windows.h>
#include <xnamath.h>
#include "d3dUtil.h"

class BlurFilter
{
public:
	BlurFilter();
	~BlurFilter();


	ID3D11ShaderResourceView* GetBlurredOutput();

	// Generuj wagi dla rozmycia gaussowskiego.
	void SetGaussianWeights(float sigma);

	// Określ wagi rozmycia samodzielnie.
	void SetWeights(const float weights[9]);

	///<summary>
	/// Wartości width i height powinny odpowiadać wymiarom wejściowej tekstury, która
	/// ma zostać rozmyta. Można wywołać Init() ponownie, aby zainicjalizować filtr 
	/// rozmycia z innymi wymiarami lub formatem.
	///</summary>
	void Init(ID3D11Device* device, UINT width, UINT height, DXGI_FORMAT format);

	///<summary>
	/// Rozmywa wejściową teksturę blurCount razy. Operuje bezpośrednio na przekazanej teksturze, nie na jej kopii.
	///</summary>
	void BlurInPlace(ID3D11DeviceContext* dc, ID3D11ShaderResourceView* inputSRV, ID3D11UnorderedAccessView* inputUAV, int blurCount);

private:

	UINT mWidth;
	UINT mHeight;
	DXGI_FORMAT mFormat;

	ID3D11ShaderResourceView* mBlurredOutputTexSRV;
	ID3D11UnorderedAccessView* mBlurredOutputTexUAV;
};

#endif // BLURFILTER_H